% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_vim.R
\name{sp_vim}
\alias{sp_vim}
\title{Shapley Population Variable Importance Measure (SPVIM) estimates}
\usage{
sp_vim(
  Y,
  X,
  V = 5,
  weights = rep(1, length(Y)),
  type = "r_squared",
  SL.library = c("SL.glmnet", "SL.xgboost", "SL.mean"),
  gamma = 1,
  alpha = 0.05,
  delta = 0,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{Y}{the outcome.}

\item{X}{the covariates.}

\item{V}{the number of folds for cross-validation, defaults to 10.}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{the type of parameter (e.g., R-squared-based is \code{"r_squared"}).}

\item{SL.library}{a character vector of learners to pass to \code{SuperLearner}, if \code{f1} and \code{f2} are Y and X, respectively. Defaults to \code{SL.glmnet}, \code{SL.xgboost}, and \code{SL.mean}.}

\item{gamma}{the fraction of the sample size to use when sampling subsets (e.g., \code{gamma = 1} samples the same number of subsets as the sample size)}

\item{alpha}{the level to compute the confidence interval at. Defaults to 0.05, corresponding to a 95\% confidence interval.}

\item{delta}{the value of the \eqn{\delta}-null (i.e., testing if importance < \eqn{\delta}); defaults to 0.}

\item{na.rm}{should we remove NA's in the outcome and fitted values in computation? (defaults to \code{FALSE})}

\item{...}{other arguments to the estimation tool, see "See also".}
}
\value{
An object of class \code{vim}. See Details for more information.
}
\description{
Compute estimates and confidence intervals for the
SPVIMs, using cross-validation.
This essentially involves splitting the data into V train/test splits; train the learners on the training data, evaluate importance on the test data; and average over these splits.
}
\details{
See the paper by Williamson and Feng (2020) for more
details on the mathematics behind this function, and the validity
of the confidence intervals.
The function works by estimating
In the interest of transparency, we return most of the calculations
within the \code{vim} object. This results in a list containing:
\itemize{
 \item{call}{ - the call to \code{cv_vim}}
 \item{SL.library}{ - the library of learners passed to \code{SuperLearner}}
\item{v}{- the estimated predictiveness measure for each sampled subset}
 \item{preds_lst}{ - the predicted values from the chosen method for each sampled subset}
 \item{est}{ - the estimated SPVIM value for each feature}
 \item{ic_lst}{ - the influence functions for each sampled subset}
 \item{ic}{- a list of the SPVIM influence function contributions}
 \item{se}{ - the standard errors for the estimated variable importance}
 \item{ci}{ - the \eqn{(1-\alpha) \times 100}\% confidence intervals based on the variable importance estimates}
 \item{gamma}{- the fraction of the sample size used when sampling subsets}
 \item{alpha}{ - the level, for confidence interval calculation}
 \item{delta}{- the \code{delta} value used for hypothesis testing}
 \item{y}{ - the outcome}
 \item{weights}{ - the weights}
 \item{mat}{- a tibble with the estimates, SEs, CIs, hypothesis testing decisions, and p-values}
}
}
\examples{
\donttest{
## don't test because this can take some time to run
library(SuperLearner)
library(gam)
n <- 100
p <- 2
## generate the data
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

## apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

## generate Y ~ Normal (smooth, 1)
y <- as.matrix(smooth + stats::rnorm(n, 0, 1))

## set up a library for SuperLearner
learners <- c("SL.mean", "SL.gam")

## -----------------------------------------
## using Super Learner
## -----------------------------------------
set.seed(4747)
est <- sp_vim(Y = y, X = x, V = 5, type = "r_squared", SL.library = learners, alpha = 0.05)
}
}
\seealso{
\code{\link[SuperLearner]{SuperLearner}} for specific usage of the \code{SuperLearner} function and package.
}
