% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_vim.R
\name{cv_vim}
\alias{cv_vim}
\title{Nonparametric Variable Importance Estimates using Cross-validation}
\usage{
cv_vim(Y, X, f1, f2, indx = 1, V = 10, folds = NULL,
  type = "regression", run_regression = TRUE, SL.library = c("SL.glmnet",
  "SL.xgboost", "SL.mean"), alpha = 0.05, na.rm = FALSE,
  update_denom = TRUE, ...)
}
\arguments{
\item{Y}{the outcome.}

\item{X}{the covariates.}

\item{f1}{the fitted values from a flexible estimation technique regressing Y on X; a list of length V.}

\item{f2}{the fitted values from a flexible estimation technique regressing the fitted values in \code{f1} on X withholding the columns in \code{indx}; a list of length V.}

\item{indx}{the indices of the covariate(s) to calculate variable importance for; defaults to 1.}

\item{V}{the number of folds for cross-validation, defaults to 10}

\item{folds}{the folds to use, if f1 and f2 are supplied}

\item{type}{the type of parameter (e.g., ANOVA-based is \code{"regression"})}

\item{run_regression}{if outcome Y and covariates X are passed to \code{vimp_regression}, and \code{run_regression} is \code{TRUE}, then Super Learner will be used; otherwise, variable importance will be computed using the inputted fitted values.}

\item{SL.library}{a character vector of learners to pass to \code{SuperLearner}, if \code{f1} and \code{f2} are Y and X, respectively. Defaults to \code{SL.glmnet}, \code{SL.xgboost}, and \code{SL.mean}.}

\item{alpha}{the level to compute the confidence interval at. Defaults to 0.05, corresponding to a 95\% confidence interval.}

\item{na.rm}{should we remove NA's in the outcome and fitted values in computation? (defaults to \code{FALSE})}

\item{update_denom}{logical; was smoothing used to estimate the denominator of the parameter of interest, if standardized? (defaults to \code{TRUE})}

\item{...}{other arguments to the estimation tool, see "See also".}
}
\value{
An object of class \code{vim}. See Details for more information.
}
\description{
Compute estimates and confidence intervals for the
nonparametric variable importance parameter of interest, using cross-validation in the updating procedure.
This essentially involves splitting the data into V train/test splits; train the learners on the training data, evaluate importance on the test data; and average over these splits.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function, and the validity
of the confidence intervals.
In the interest of transparency, we return most of the calculations
within the \code{vim} object. This results in a list containing:
\itemize{
 \item{call}{ - the call to \code{cv_vim}}
 \item{s}{ - the column(s) to calculate variable importance for}
 \item{SL.library}{ - the library of learners passed to \code{SuperLearner}}
 \item{full_fit}{ - the fitted values of the chosen method fit to the full data}
 \item{red_fit}{ - the fitted values of the chosen method fit to the reduced data}
 \item{est}{ - the estimated variable importance}
 \item{naive}{ - the naive estimator of variable importance}
 \item{update}{ - the influence curve-based update}
 \item{se}{ - the standard error for the estimated variable importance}
 \item{ci}{ - the \eqn{(1-\alpha) \times 100}\% confidence interval for the variable importance estimate}
 \item{full_mod}{ - the object returned by the estimation procedure for the full data regression (if applicable)}
 \item{red_mod}{ - the object returned by the estimation procedure for the reduced data regression (if applicable)}
 \item{alpha}{ - the level, for confidence interval calculation}
}
}
\examples{
\donttest{
library(SuperLearner)
library(gam)
n <- 100
p <- 2
## generate the data
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

## apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

## generate Y ~ Normal (smooth, 1)
y <- smooth + stats::rnorm(n, 0, 1)

## set up a library for SuperLearner
learners <- c("SL.mean", "SL.gam")


## using Super Learner
est <- cv_vim(Y = y, X = x, indx = 2, V = 5, 
type = "regression", run_regression = TRUE, 
SL.library = learners, alpha = 0.05)
}

}
\seealso{
\code{\link[SuperLearner]{SuperLearner}} for specific usage of the \code{SuperLearner} function and package.
}
