% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker.R
\name{vetiver_sm_build}
\alias{vetiver_sm_build}
\alias{vetiver_sm_model}
\alias{vetiver_sm_endpoint}
\title{Deploy a vetiver model API to Amazon SageMaker with modular functions}
\usage{
vetiver_sm_build(
  board,
  name,
  version = NULL,
  path = fs::dir_create(tempdir(), "vetiver"),
  predict_args = list(),
  docker_args = list(),
  repository = NULL,
  compute_type = c("BUILD_GENERAL1_SMALL", "BUILD_GENERAL1_MEDIUM",
    "BUILD_GENERAL1_LARGE", "BUILD_GENERAL1_2XLARGE"),
  role = NULL,
  bucket = NULL,
  vpc_id = NULL,
  subnet_ids = list(),
  security_group_ids = list(),
  log = TRUE,
  ...
)

vetiver_sm_model(
  image_uri,
  model_name,
  role = NULL,
  vpc_config = list(),
  enable_network_isolation = FALSE,
  tags = list()
)

vetiver_sm_endpoint(
  model_name,
  instance_type,
  endpoint_name = NULL,
  initial_instance_count = 1,
  accelerator_type = NULL,
  tags = list(),
  kms_key = NULL,
  data_capture_config = list(),
  volume_size = NULL,
  model_data_download_timeout = NULL,
  wait = TRUE
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_connect]{board_connect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[pins:pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{path}{A path to write the Plumber file, Dockerfile, and lockfile,
capturing the model's dependencies.}

\item{predict_args}{A list of optional arguments passed to \code{\link[=vetiver_api]{vetiver_api()}}
such as the prediction \code{type}.}

\item{docker_args}{A list of optional arguments passed to
\code{\link[=vetiver_write_docker]{vetiver_write_docker()}} such as the \code{lockfile} name or whether to use
\code{rspm}. Do not pass \code{additional_pkgs} here, as this function uses
\code{additional_pkgs = required_pkgs(board)}.}

\item{repository}{The ECR repository and tag for the image as a character.
Defaults to \verb{sagemaker-studio-$\{domain_id\}:latest}.}

\item{compute_type}{The \href{https://aws.amazon.com/codebuild/}{CodeBuild}
compute type as a character. Defaults to \code{BUILD_GENERAL1_SMALL}.}

\item{role}{The ARN role for the Amazon SageMaker model. Defaults to the
SageMaker execution role.}

\item{bucket}{The S3 bucket to use for sending data to CodeBuild as a
character. Defaults to the SageMaker SDK default bucket.}

\item{vpc_id}{ID of the VPC that will host the CodeBuild project such as
\code{"vpc-05c09f91d48831c8c"}.}

\item{subnet_ids}{List of subnet IDs for the CodeBuild project, such as
\code{list("subnet-0b31f1863e9d31a67")}.}

\item{security_group_ids}{List of security group IDs for the CodeBuild
project, such as \code{list("sg-0ce4ec0d0414d2ddc")}.}

\item{log}{A logical to show the logs of the running CodeBuild build.
Defaults to \code{TRUE}.}

\item{...}{\href{https://docs.docker.com/engine/reference/commandline/build/#options>}{Docker build parameters}
(Use "_" instead of "-"; for example, Docker optional parameter
\code{build-arg} becomes \code{build_arg}).}

\item{image_uri}{The AWS ECR image URI for the Amazon SageMaker Model to be
created (for example, as returned by \code{\link[=vetiver_sm_build]{vetiver_sm_build()}}).}

\item{model_name}{The Amazon SageMaker model name to be deployed.}

\item{vpc_config}{A list containing the VPC configuration for the Amazon
SageMaker model \href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html}{API VpcConfig}
(optional).
\itemize{
\item \code{Subnets}: List of subnet ids
\item \code{SecurityGroupIds}: List of security group ids
}}

\item{enable_network_isolation}{A logical to specify whether the container
will run in network isolation mode. Defaults to \code{FALSE}.}

\item{tags}{A named list of tags for labeling the Amazon SageMaker model or
model endpint to be created.}

\item{instance_type}{Type of EC2 instance to use; see
\href{https://aws.amazon.com/sagemaker/pricing/}{Amazon SageMaker pricing}.}

\item{endpoint_name}{The name to use for the Amazon SageMaker model endpoint
to be created, if to be different from \code{model_name}.}

\item{initial_instance_count}{The initial number of instances to run
in the endpoint.}

\item{accelerator_type}{Type of Elastic Inference accelerator to
attach to an endpoint for model loading and inference, for
example, \code{"ml.eia1.medium"}.}

\item{kms_key}{The ARN of the KMS key used to encrypt the data on the
storage volume attached to the instance hosting the endpoint.}

\item{data_capture_config}{A list for configuration to control how Amazon
SageMaker captures inference data.}

\item{volume_size}{The size, in GB, of the ML storage volume attached to
the individual inference instance associated with the production variant.
Currently only Amazon EBS gp2 storage volumes are supported.}

\item{model_data_download_timeout}{The timeout value, in seconds, to download
and extract model data from Amazon S3.}

\item{wait}{A logical for whether to wait for the endpoint to be deployed.
Defaults to \code{TRUE}.}
}
\value{
\code{vetiver_sm_build()} returns the AWS ECR image URI and
\code{vetiver_sm_model()} returns the model name (both as characters).
\code{vetiver_sm_endpoint()} returns a new \code{\link[=vetiver_endpoint_sagemaker]{vetiver_endpoint_sagemaker()}} object.
}
\description{
Use the function \code{\link[=vetiver_deploy_sagemaker]{vetiver_deploy_sagemaker()}} for basic deployment on
SageMaker, or these three functions together for more advanced use cases:
\itemize{
\item \code{vetiver_sm_build()} generates and builds a Docker image on SageMaker for
a vetiver model
\item \code{vetiver_sm_model()} creates an Amazon SageMaker model
\item \code{vetiver_sm_endpoint()} deploys an Amazon SageMaker model endpoint
}
}
\details{
The function \code{vetiver_sm_build()} generates the files necessary to
build a Docker container to deploy a vetiver model in SageMaker and then
builds the image on \href{https://aws.amazon.com/codebuild/}{AWS CodeBuild}. The
resulting image is stored in \href{https://aws.amazon.com/ecr/}{AWS ECR}.
This function creates a Plumber file and Dockerfile appropriate for
SageMaker, for example, with \code{path = "/invocations"} and \code{port = 8080}.

If you run into problems with Docker rate limits, then either
\itemize{
\item authenticate to Docker from SageMaker, or
\item use a \href{https://gallery.ecr.aws/docker/library/r-base}{public ECR base image},
passed through \code{docker_args}
}
}
\examples{
if (FALSE) {
library(pins)
b <- board_s3(bucket = "my-existing-bucket")
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)

new_image_uri <- vetiver_sm_build(
    board = b,
    name = "cars_linear",
    predict_args = list(type = "class", debug = TRUE),
    docker_args = list(
        base_image = "FROM public.ecr.aws/docker/library/r-base:4.2.2"
    )
)

model_name <- vetiver_sm_model(
    new_image_uri,
    tags = list("my_custom_tag" = "fuel_efficiency")
)

vetiver_sm_endpoint(model_name, "ml.t2.medium")
}
}
\seealso{
\code{\link[=vetiver_prepare_docker]{vetiver_prepare_docker()}}, \code{\link[=vetiver_deploy_sagemaker]{vetiver_deploy_sagemaker()}}, \code{\link[=vetiver_endpoint_sagemaker]{vetiver_endpoint_sagemaker()}}
}
