% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach-pkgs.R
\name{attach_pkgs}
\alias{attach_pkgs}
\alias{load_pkgs}
\title{Fully attach or load packages for making model predictions}
\usage{
attach_pkgs(pkgs)

load_pkgs(pkgs)
}
\arguments{
\item{pkgs}{A character vector of package names to load or fully attach.}
}
\value{
An invisible \code{TRUE}.
}
\description{
These are developer-facing functions, useful for supporting new model types.
Some models require one or more R packages to be fully attached to make
predictions, and some require only that the namespace of one or more R
packages is loaded.
}
\details{
These two functions will attempt either to:
\itemize{
\item fully attach or
\item load
}

the namespace of the \code{pkgs} vector of package names, preserving the current
random seed.

To learn more about load vs. attach, read the \href{https://r-pkgs.org/namespace.html}{NAMESPACE chapter of \emph{R Packages}}. For deploying a model, it
is likely safer to fully attach needed packages but that comes with the risk
of naming conflicts between packages.
}
\examples{
## succeed
load_pkgs(c("knitr", "readr"))
attach_pkgs(c("knitr", "readr"))

## fail
try(load_pkgs(c("bloopy", "readr")))
try(attach_pkgs(c("bloopy", "readr")))

}
\concept{namespace}
