% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value-diffs.R
\name{value_diffs}
\alias{value_diffs}
\alias{value_diffs_stacked}
\alias{value_diffs_all}
\title{Show the differing values from a comparison}
\usage{
value_diffs(comparison, column)

value_diffs_stacked(comparison, column)

value_diffs_all(comparison)
}
\arguments{
\item{comparison}{The output of \code{compare()}}

\item{column}{<\code{\link[=versus_tidy_select]{tidy-select}}>. The output will show the differing values
for the provided columns.}
}
\value{
\item{\code{value_diffs()}}{A data frame with one row for each element
of \code{col} found to be unequal between the input tables (
\code{table_a} and \code{table_b} from the original \code{compare()} output)
The output table has the column specified by \code{column} from each of the
input tables, plus the \code{by} columns. }

\item{\code{value_diffs_stacked()}, \code{value_diffs_all()}}{A data frame containing
the \code{value_diffs()} outputs for the specified columns combined row-wise
using \code{dplyr::bind_rows()}. If \code{dplyr::bind_rows()} is not possible
due to incompatible types, values are converted to character first.
\code{value_diffs_all()} is the same as \code{value_diffs_stacked()} with
\code{column = everything()}}
}
\description{
Show the differing values from a comparison
}
\examples{
comp <- compare(example_df_a, example_df_b, by = car)
value_diffs(comp, disp)
value_diffs_stacked(comp, c(disp, mpg))
}
