% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_focal.R
\name{VeloxRaster_meanFocal}
\alias{VeloxRaster_meanFocal}
\title{Mean focal}
\arguments{
\item{weights}{A numeric matrix of weights. Both dimensions must be uneven.}

\item{bands}{Numeric vector indicating bands where filter is applied.}
}
\value{
Void.
}
\description{
Applies a mean filter with weights matrix \code{weights} to a VeloxRaster.
}
\details{
Padding is currently not implemented.
}
\examples{
## Make VeloxRaster with two bands
mat1 <- matrix(1:100, 10, 10)
mat2 <- matrix(100:1, 10, 10)
vx <- velox(list(mat1, mat2), extent=c(0,1,0,1), res=c(0.1,0.1),
            crs="+proj=longlat +datum=WGS84 +no_defs")
## Mean focal
weights <- matrix(1, 5, 5)
vx$meanFocal(weights=weights, bands=c(1,2))

}

