% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netspeed.R
\name{netspeed}
\alias{netspeed}
\title{Calculate speeds of traffic network}
\usage{
netspeed(q = 1, ps, ffs, cap, lkm, alpha = 0.15, beta = 4, net, scheme = FALSE)
}
\arguments{
\item{q}{Data-frame of traffic flow to each hour (veh/h)}

\item{ps}{Peak speed (km/h)}

\item{ffs}{Free flow speed (km/h)}

\item{cap}{Capacity of link (veh/h)}

\item{lkm}{Distance of link (km)}

\item{alpha}{Parameter of BPR curves}

\item{beta}{Parameter of BPR curves}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{scheme}{Logical to create a Speed data-frame with 24 hours and a
default  profile. It needs ffs and ps:
\tabular{rl}{
  00:00-06:00 \tab ffs\cr
  06:00-07:00 \tab average between ffs and ps\cr
  07:00-10:00 \tab ps\cr
  10:00-17:00 \tab average between ffs and ps\cr
  17:00-20:00 \tab ps\cr
  20:00-22:00 \tab average between ffs and ps\cr
  22:00-00:00 \tab ffs\cr
}}
}
\value{
dataframe speeds with units or sf.
}
\description{
\code{netspeed} Creates a dataframe of speeds fir diferent hours
and each link based on morning rush traffic data
}
\examples{
\dontrun{
data(net)
data(pc_profile)
pc_week <- temp_fact(net$ldv+net$hdv, pc_profile)
df <- netspeed(pc_week, net$ps, net$ffs, net$capacity, net$lkm, alpha = 1)
class(df)
plot(df) #plot of the average speed at each hour, +- sd
df <- netspeed(ps = net$ps, ffs = net$ffs, scheme = TRUE)
class(df)
plot(df) #plot of the average speed at each hour, +- sd
dfsf <- netspeed(ps = net$ps, ffs = net$ffs, scheme = TRUE, net = net)
class(dfsf)
head(dfsf)
plot(dfsf) #plot of the average speed at each hour, +- sd
}
}
