% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_taxa.R
\name{merge_taxa}
\alias{merge_taxa}
\alias{merge_taxa,vegtable,numeric,missing-method}
\alias{merge_taxa,vegtable,missing,character-method}
\alias{merge_taxa,vegtable,missing,missing-method}
\alias{taxa2samples}
\alias{taxa2samples,vegtable-method}
\title{Merge concepts}
\usage{
\S4method{merge_taxa}{vegtable,numeric,missing}(object, concepts, level, ...)

\S4method{merge_taxa}{vegtable,missing,character}(object, concepts, level, ...)

taxa2samples(object, ...)

\S4method{taxa2samples}{vegtable}(object, merge_to, include_levels, na.rm = FALSE, add_traits, ...)
}
\arguments{
\item{object}{Object of class \linkS4class{vegtable}.}

\item{concepts}{Numeric (integer) vector including taxon concepts to be
merged.}

\item{level, merge_to}{Character value indicating the level to which the taxa
have to be merged.}

\item{...}{Further arguments passed to \code{\link[taxlist:merge_taxa]{taxlist::merge_taxa()}}.}

\item{include_levels}{Character vector indicating the levels to be considered
in the output object. It can be used to exclude some taxonomic ranks.}

\item{na.rm}{Logical value. Apply to records with missing information on
taxonomic rank (i.e. for undetermined specimens).}

\item{add_traits}{A character vector indicating variables in the slot
\code{taxonTraits} to be added in slot \code{samples}.}
}
\value{
An object of class \linkS4class{vegtable}.
}
\description{
Merge taxon concepts form into single ones or insert accepted names to slot
samples.

This method is applied to a function defined in the package \link{taxlist-package}
and only modify the slot \code{species} in the input \code{object}.

The use of \code{taxa2samples()} with \code{merge_to} argument will produce a similar
result as using \code{merge_taxa} with \code{level} argument, but \code{taxa2samples()}
will replace the records in slot samples by the respective accepted names
without any modification in slot species.
Additionally taxon concept IDs will be addes as columns in samples and taxon
traits if indicated in argument \code{add_traits}.
}
\examples{
## Merge Olea capensis into one
summary(subset(Kenya_veg@species, grepl("Olea capensis", TaxonName),
	   slot="names"), "all")
Kenya_veg <- merge_taxa(Kenya_veg, c(52041,50432,50235))

## Check Olea capensis again
summary(subset(Kenya_veg@species, grepl("Olea capensis", TaxonName),
	   slot="names"), "all")

## Effect of taxa2samples by counting taxa
count_taxa(Kenya_veg, level="genus")

Kenya_veg <- taxa2samples(Kenya_veg, merge_to="genus")
count_taxa(Kenya_veg, level="genus")

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
