% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2vegtable.R
\name{df2vegtable}
\alias{df2vegtable}
\alias{df2vegtable,data.frame,numeric,numeric-method}
\alias{df2vegtable,data.frame,numeric,missing-method}
\title{Convert a data frame into a vegtable object.}
\usage{
df2vegtable(x, species, layer, ...)

\S4method{df2vegtable}{data.frame,numeric,numeric}(x, species, layer, ...)

\S4method{df2vegtable}{data.frame,numeric,missing}(x, species, layer, ...)
}
\arguments{
\item{x}{A data frame formatted for a taxlist object.}

\item{species}{Numeric or integer indicating the position of the column with
species names.}

\item{layer}{Numeric or integer indicating the position of the column with
layers.}

\item{...}{Further arguments passed from or to other methods.}
}
\value{
A \linkS4class{vegtable} object.
}
\description{
Conversion of a data frame containing a cross table of abundance or cover of
species in single plots.

This function coerces a data frame containing a vegetation cross table into
a \linkS4class{vegtable} object. The input data frame \code{x} may include information
on the layers or not.
}
\examples{
## Creating data set 'dune_veg'
library(vegan)

## Load data from vegan
data(dune)
data(dune.env)

## Conversion to vegtable
dune_veg <- data.frame(species=colnames(dune), t(dune),
    stringsAsFactors=FALSE, check.names=FALSE)
dune_veg <- df2vegtable(dune_veg, species=1)

summary(dune_veg)

## Adding environmental variables
dune.env$ReleveID <- as.integer(rownames(dune.env))
header(dune_veg) <- dune.env

summary(dune_veg)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
