% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shaker-class.R
\docType{class}
\name{shaker-class}
\alias{shaker-class}
\alias{shaker}
\title{Class containing Cocktail algorithms.}
\description{
Objects used for collecting Cocktail definitions.

These objects work as \bold{expert systems} for recognition of defined
vegetation units among plots of a \linkS4class{vegtable} object.
A \code{shaker} object will be always dependent on a \linkS4class{vegtable} object,
which is called \code{companion}.
Since modifications in the \code{companion} may affect the functionality of
the \code{shaker} object, it will be recommended to create the last during
a session by a source script instead of recycling them from old R images.
}
\section{Slots}{

\describe{
\item{\code{pseudos}}{List containing IDs of taxa that will be merged into
pseudo-species.}

\item{\code{groups}}{List containing IDs of taxa belonging to the same Cocktail
group.}

\item{\code{dominants}}{A data frame including lists of species used as dominant
species in Cocktail algorithms, as well as operators and cover values
used in the formulas.}

\item{\code{formulas}}{List with formulas that will be used as definitions for
vegetation units.}
}}

\examples{
showClass("shaker")

}
\seealso{
\code{\link[=make_cocktail]{make_cocktail()}} \code{\link[=set_pseudo]{set_pseudo()}} \code{\link[=set_group]{set_group()}} \code{\link[=set_formula]{set_formula()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
