% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dwd.R
\name{read.DWDdata}
\alias{read.DWDdata}
\title{Fetch meteo data of DWD weather stations}
\usage{
read.DWDdata(id, type = "climate", period = "recent",
  resolution = "daily", file = NULL, destdir = NULL, quiet = FALSE)
}
\arguments{
\item{id}{integer. A valid station id (cf. \link{read.DWDstations}).}

\item{type}{string. Stations can be of type \samp{"climate"} offering a range
of meteorological parameters or of type \samp{"precipitation"} solely
recording rainfall. There are about 400 \samp{climate} and 2000
\samp{precipitation} stations.}

\item{period}{string specifying a time span. The last 1.5 years are
called \samp{"recent"}. Data from the individual beginning of measurements
up to a year ago are labelled \samp{"historical"}.
\samp{"recent"} data have not yet gone through the full quality control
procedure. \samp{"historical"} data have completed the operational quality
control. But be aware there still might be gaps and inhomogeneities.}

\item{resolution}{string. Temporal resolution of the data can be
\samp{"daily"} or \samp{"monthly"}. \samp{"daily"} being the common
resolution.}

\item{file}{a string specifying the location of a dataset. \samp{"file"}
may point to a file on a FTP server or on the local file system.
If the file lives on a FTP server the string must start with
\code{'ftp://'}. If it is NULL (the default), data will be downloaded
from DWD's FTP server.}

\item{destdir}{directory (string) where intermediate data (downloaded *.zip
file) are stored. If it is NULL (the default) a subdirectory
\samp{downloaded_packages} of the session temporary directory will be used
(and the files will be deleted at the end of the session).
It might be advisable to keep the .zip file since it contains the
stations documentation and metadata (e.g. station shift, used devices,
downtimes etc.).}

\item{quiet}{If TRUE, suppress status messages (if any), and the progress bar.}
}
\value{
A data.frame with the observed weather data. Beware of gaps and
  inhomogeneities! \samp{colnames} contains the original header and
  hence German terms.

  Content of 'climate'-data.frame:
  \tabular{ll}{
   \strong{Name} \tab \strong{Description}\cr
   STATIONS_ID \tab station id\cr
   MESS_DATUM  \tab date\cr
   QN_3        \tab quality level of next columns (-)\cr
   FX          \tab daily maximum of wind gust (m/s)\cr
   FM          \tab daily mean of wind velocity (m/s)\cr
   QN_4        \tab quality level of next columns (-)\cr
   RSK         \tab daily precipitation height (mm)\cr
   RSKF        \tab precipitation form (-)\cr
   SDK         \tab daily sunshine duration (h)\cr
   SHK_TAG     \tab daily snow depth (cm)\cr
   NM          \tab daily mean of cloud cover (1/8)\cr
   VPM         \tab daily mean of vapor pressure (hPa)\cr
   PM          \tab daily mean of pressure (hPa)\cr
   TMK         \tab daily mean of temperature (°C)\cr
   UPM         \tab daily mean of relative humidity (\%)\cr
   TXK         \tab daily maximum of temperature at 2m height (°C)\cr
   TNK         \tab daily minimum of temperature at 2m height (°C)\cr
   TGK         \tab daily minimum of air temperature at 5cm above ground (°C)
  }

  Content of 'precipitation'-data.frame:
  \tabular{ll}{
   \strong{Name} \tab \strong{Description}\cr
   STATIONS_ID \tab station id\cr
   MESS_DATUM  \tab date\cr
   QN_6        \tab quality level of next columns (-)\cr
   RS          \tab daily precipitation height (mm)\cr
   RSF         \tab precipitation form (-)\cr
   SH_TAG      \tab daily height of snow pack (cm)\cr
  }
}
\description{
Fetch observed meteorological data of German weather stations from freely
accessible part of the Climate Data Center of Germany's National
Meteorological Service (Deutscher Wetterdienst, DWD).
}
\details{
An introduction to the data available at the Climate Data Center can be
found in the German
\href{ftp://ftp-cdc.dwd.de/pub/CDC/Liesmich_intro_CDC-FTP.pdf}{Liesmich_intro_CDC_ftp}
or the translated
\href{ftp://ftp-cdc.dwd.de/pub/CDC/Readme_intro_CDC_ftp.pdf}{Readme_intro_CDC_ftp}.

The freely accessible part of the Climate Data Center of Germany's National
Meteorological Service (Deutscher Wetterdienst, DWD) is part of the DWD's
mandate for basic supply of information (termed "Grundversorgung").
These services may be used without any restrictions (no fees will be charged
and in general there are no restrictions for the use the data), provided
that the source is indicated as laid down in the
\href{http://www.gesetze-im-internet.de/geonutzv/BJNR054700013.html}{"GeoNutzV"}
ordinance. The source reference shall roughly meet the following rules:
\itemize{
  \item Where data are used without modification, the source reference shall
    read "Source: Deutscher Wetterdienst" or just consist of the DWD logo.
  \item If the data are modified, the source reference shall specify as
    precisely as possible the extent of such, e.g. "Based on data from
    Deutscher Wetterdienst, figures rounded".
}
A more detailed description of the rules can be found in the official and
legally binding German
\href{ftp://ftp-cdc.dwd.de/pub/CDC/Nutzungsbedingungen_German.pdf}{Nutzungsbedingungen}
or the translated \href{ftp://ftp-cdc.dwd.de/pub/CDC/Terms_of_use.pdf}{Terms
of use}.
}
\examples{
\dontrun{
# fetch last 500 days worth of data from station Göttingen
clim <- read.DWDdata(id=1691)

# save data & metadata (documentation about devices, downtimes etc.)
clim <- read.DWDdata(id=1691, destdir='.')

# find and download historical data from the Brocken
stat.hist <- read.DWDstations(period='historical')
brocken.id <- stat.hist[grep("^Brock", stat.hist$name), ]$id
clim.brocken <- read.DWDdata(id=brocken.id, period='historical')
}

}
\references{
Freely accessible DWD data available via the
  \href{https://www.dwd.de/EN/climate_environment/cdc/cdc.html}{Climate Data Center}.
}
