% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autosize.R
\name{vw_autosize}
\alias{vw_autosize}
\title{Autosize vegaspec}
\usage{
vw_autosize(spec, width = NULL, height = NULL)
}
\arguments{
\item{spec}{An object to be coerced to \code{vegaspec}, a Vega/Vega-Lite specification}

\item{width}{\code{integer}, if specified, the total rendered width (in pixels)
of the chart - valid only for single-view charts and layered charts;
the default is to use the width in the chart specification}

\item{height}{\code{integer}, if specified, the total rendered height (in pixels)
of the chart - valid only for single-view charts and layered charts;
the default is to use the height in the chart specification}
}
\value{
S3 object with class \code{vegaspec}
}
\description{
The arguments \code{width} and \code{height} are used to override the width and height
of the provided \code{spec}, if the \code{spec} does not have multiple views.
The dimensions you provide describe the overall width and height of the
rendered chart, including axes, labels, legends, etc.
}
\details{
In a Vega or Vega-Lite specification, the default interpretation
of width and height is to describe the dimensions of the
\strong{data rectangle}, not including the space used by the axes, labels,
legends, etc. When \code{width} and \code{height} are specified using
\href{https://vega.github.io/vega-lite/docs/size.html#autosize}{autosize},
the meanings of \code{width} and \code{height} change to describe the dimensions
of the \strong{entire chart}, including axes, labels, legends, etc.

There is an important limitation: specifying \code{width} and \code{height} is
\href{https://vega.github.io/vega-lite/docs/size.html#limitations}{effective only for single-view and layered specifications}.
It will not work for specifications with multiple views
(e.g. \code{hconcat}, \code{vconcat}, \code{facet}, \code{repeat}); this will issue a
warning that there will be no effect on the specification when rendered.
}
\examples{
  vw_autosize(spec_mtcars, width = 350, height = 350)
}
\seealso{
\href{https://vegawidget.github.io/vegawidget/articles/articles/vegaspec.html#sizing}{Article on vegaspec (sizing)},
\href{https://vega.github.io/vega-lite/docs/size.html#autosize}{Vega documentation on sizing}
}
