% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vega-embed.R
\name{vega_embed}
\alias{vega_embed}
\title{Vega embed options}
\usage{
vega_embed(
  renderer = c("canvas", "svg"),
  actions = NULL,
  defaultStyle = TRUE,
  mode = NULL,
  theme = NULL,
  logLevel = NULL,
  tooltip = NULL,
  loader = NULL,
  patch = NULL,
  width = NULL,
  height = NULL,
  padding = NULL,
  scaleFactor = NULL,
  config = NULL,
  editorUrl = NULL,
  sourceHeader = NULL,
  sourceFooter = NULL,
  hover = NULL,
  i18n = NULL,
  downloadFileName = NULL,
  formatLocale = NULL,
  timeFormatLocale = NULL
)
}
\arguments{
\item{renderer}{\code{character} the renderer to use for the view.
One of \code{"canvas"} (default) or \code{"svg"}.
See \href{https://vega.github.io/vega/docs/api/view/#view_renderer}{Vega docs}
for details.}

\item{actions}{\code{logical} or named vector of logicals, determines if action links
("Export as PNG/SVG", "View Source", "Open in Vega Editor")
are included with the embedded view.
If the value is \code{TRUE} (default), all action links will be shown
and none if the value is \code{FALSE}. This property can be a named vector of
logicals that maps
keys (\code{export}, \code{source}, \code{compiled}, \code{editor}) to logical values for determining
if each action link should be shown. By default, \code{export}, \code{source},
and \code{editor} are \code{TRUE} and \code{compiled} is \code{FALSE}, but these defaults
can be overridden. For example, if \code{actions} is
\code{list(export =  FALSE, source = TRUE)}, the embedded visualization will
have two links – "View Source" and "Open in Vega Editor".}

\item{defaultStyle}{\code{logical} or \code{character}
default stylesheet for embed actions}

\item{mode}{\code{character} if specified, tells Vega-Embed to parse the spec
as vega or vega-lite. Vega-Embed will parse the \verb{$schema} url if the mode
is not specified. Vega-Embed will default to vega if neither mode,
nor $schema are specified.}

\item{theme}{\code{character} if specified, tells Vega-Embed use the theme from
\href{https://github.com/vega/vega-themes}{Vega Themes};
this is an experimental feature.}

\item{logLevel}{sets the current log level.
See \href{https://vega.github.io/vega/docs/api/view/#view_logLevel}{Vega docs}
for details.}

\item{tooltip}{\code{JS}, \code{logical}, or object
to provide a \href{https://vega.github.io/vega/docs/api/view/#view_tooltip}{tooltip handler},
customize the default \href{https://github.com/vega/vega-tooltip}{Vega Tooltip handler},
or disable the default handler.}

\item{loader}{\code{list}, sets a custom Vega loader.
See \href{https://github.com/vega/vega-loader#loader}{Vega docs}
for details.}

\item{patch}{\code{JS} function or object, A function to modify the Vega
specification before it is parsed. Alternatively, an object that is used
to patch the Vega specification. If you use Vega-Lite, the compiled Vega
will be patched.}

\item{width}{\code{integer}, sets the view width in pixels.
See \href{https://vega.github.io/vega/docs/api/view/#view_width}{Vega docs}
for details.
Note that Vega-Lite overrides this option.}

\item{height}{\code{integer}, sets the view height in pixels.
See \href{https://vega.github.io/vega/docs/api/view/#view_height}{Vega docs}
for details.
Note that Vega-Lite overrides this option.}

\item{padding}{\code{list}, sets the view padding in pixels.
See \href{https://vega.github.io/vega/docs/api/view/#view_padding}{Vega docs}
for details.}

\item{scaleFactor}{\code{numeric} the number by which to multiply the width and
height (default 1) of an exported PNG or SVG image.}

\item{config}{\code{character} or \code{list}, a URL string from which to load
a Vega/Vega-Lite or Vega-Lite configuration file, or a \code{list} of
Vega/Vega-Lite configurations to override the default configuration
options. If \code{config} is a URL, it will be subject to standard browser
security restrictions. Typically this URL will point to a file on the same
host and port number as the web page itself.}

\item{editorUrl}{\code{character}, URL at which to open embedded Vega specs
in a Vega editor. Defaults to \code{"http://vega.github.io/editor/"}.
Internally, Vega-Embed uses
\href{https://developer.mozilla.org/en-US/docs/Web/API/Window/postMessage}{HTML5 postMessage}
to pass the specification information to the editor.}

\item{sourceHeader}{\code{character}, HTML to inject into the `` tag of the
page generated by the "View Source" action link. For example, this
can be used to add code for \href{https://highlightjs.org/}{syntax highlighting}.}

\item{sourceFooter}{\code{character}, HTML to inject into the end of the
page generated by the "View Source" action link. The text will be added
immediately before the closing `` tag.}

\item{hover}{\code{logical}, enable \href{https://vega.github.io/vega/docs/api/view/#view_hover}{hover event processing}}

\item{i18n}{\code{list}, this property maps keys
(COMPILED_ACTION, EDITOR_ACTION, PNG_ACTION, SOURCE_ACTION, SVG_ACTION)
to string values for the action's text. By default, the text is in English.}

\item{downloadFileName}{\code{character}, sets the file name (default: \code{visualization})
for charts downloaded using the \code{png} or \code{svg} action.}

\item{formatLocale}{\code{list}, sets the default locale definition for number formatting.
See the \href{https://github.com/d3/d3-format/tree/master/locale}{d3-format locale collection}
for definition files for a variety of languages. Note that this is a global setting.}

\item{timeFormatLocale}{\code{list}, sets the default locale definition for date/time formatting.
See the \href{https://github.com/d3/d3-time-format/tree/master/locale}{d3-time-format locale collection}
for definition files for a variety of languages. Note that this is a global setting.}
}
\value{
\code{list} to to be used with vega-embed JavaScript library
}
\description{
Helper-function to specify the \code{embed} argument to \code{vegawidget()}.
These arguments reflect the options to the
\href{https://github.com/vega/vega-embed/#options}{vega-embed}
library, which ultimately renders the chart specification as HTML.
}
\details{
The most important arguments are \code{renderer}, \code{actions}, and \code{defaultStyle}:
\itemize{
\item The default \code{renderer} is \code{"canvas"}.
\item The default for \code{actions} is \code{NULL}, which means that the \code{export},
\code{source}, and \code{editor} links are shown, but the \code{compiled} link is
not shown.
\itemize{
\item To suppress all action links, call with \code{actions = FALSE}.
\item To change from the default for a given action link, call with a list:
\code{actions = list(editor = FALSE)}.
}
\item The default for \code{defaultStyle} is \code{TRUE}, which means that action-links
are rendered in a widget at the upper-right corner of the rendered chart.
}

It is ineffective to set the \code{width} and \code{height} parameters here when
embedding a Vega-Lite specification, as they will be overridden by the values
in the chart specification.
}
\examples{
vega_embed(renderer = "svg")

}
\seealso{
\href{https://github.com/vega/vega-embed}{vega-embed library},
\code{\link[=vegawidget]{vegawidget()}}
}
