% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInfectionRate.R
\name{getInfectionRate}
\alias{getInfectionRate}
\title{Calculate infection rate}
\usage{
getInfectionRate(
  pools,
  interval,
  target_disease,
  pt_estimate,
  scale = 1000,
  species = NULL,
  trap = NULL,
  sex = "female",
  separate_by = NULL,
  wide = FALSE
)
}
\arguments{
\item{pools}{Pools data retrieved from `getPools()`}

\item{interval}{Calculation interval for infection rate, accepts “collection_date”,“Biweek”,“Week”, and “Month}

\item{target_disease}{The disease to calculate infection rate for–i.e. “WNV”. Disease acronyms are the accepted input. To see a list of disease acronyms, run `unique(pools$target_acronym)`}

\item{pt_estimate}{The estimation type for infection rate. Options include: “mle”,“bc-mle”, “mir”}

\item{scale}{Constant to multiply infection rate by}

\item{species}{An optional vector for filtering species. Species_display_name is the accepted notation.To see a list of species present in your data run unique(collections$species_display_name). If species is unspecified, the default NULL will return data for all species in data.}

\item{trap}{An optional vector for filtering trap type by acronym. Trap_acronym is the is the accepted notation. Run unique(collections$trap_acronym) to see trap types present in your data. If trap is unspecified, the default NULL will return data for all trap types.}

\item{sex}{An optional vector for filtering sex type. Accepts 'male', 'female',or 'other'. If sex is unspecified, the default NULL will return data for female sex.}

\item{separate_by}{Separate/group the calculation by 'trap','species' or 'agency'. Default NULL does not separate.}

\item{wide}{Should the data be returned in wide/spreadsheet format}
}
\value{
Dataframe of infection rate calculation
}
\description{
`getInfectionRate()` requires at least five years prior to the target_year of arthro collections data to calculate for the specified parameters. The function uses the methods of the Gateway Abundance Anomaly calculator, and will not work if there is fewer than five years of data present.
}
\keyword{infection}
\keyword{pools}
\keyword{rate}
