% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.propratio2}
\alias{meta.lm.propratio2}
\title{Meta-regression analysis for proportion ratios}
\usage{
meta.lm.propratio2(alpha, f1, f2, n1, n2, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 frequency counts}

\item{f2}{vector of group 2 frequency counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - the exponentiated estimate
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a log
proportion ratio. The estimates are OLS estimates with robust standard
errors that accommodate residual heteroscedasticity. The exponentiated
slope estimate for a predictor variable describes a multiplicative
change in the proportion ratio associated with a 1-unit increase in
that predictor variable.
}
\examples{
n1 <- c(204, 201, 932, 130, 77)
n2 <- c(106, 103, 415, 132, 83)
f1 <- c(24, 40, 93, 14, 5)
f2 <- c(12, 9, 28, 3, 1)
x1 <- c(4, 4, 5, 3, 26)
x2 <- c(1, 1, 1, 0, 0)
X <- matrix(cbind(x1, x2), 5, 2)
meta.lm.propratio2(.05, f1, f2, n1, n2, X)

# Should return:
#         Estimate         SE           z     p          LL         UL
# b0  1.4924887636 0.69172794  2.15762393 0.031  0.13672691 2.84825062
# b1  0.0005759509 0.04999884  0.01151928 0.991 -0.09741998 0.09857188
# b2 -1.0837844594 0.59448206 -1.82307345 0.068 -2.24894789 0.08137897
#     exp(Estimate)   exp(LL)   exp(UL)
# b0      4.4481522 1.1465150 17.257565
# b1      1.0005761 0.9071749  1.103594
# b2      0.3383128 0.1055102  1.084782


}
\references{
\insertRef{Price2008}{vcmeta}
}
