% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.gen}
\alias{meta.lm.gen}
\title{Meta-regression analysis for any type of effect size}
\usage{
meta.lm.gen(alpha, est, se, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est}{vector of parameter estimates}

\item{se}{vector of standard errors}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is any type of
effect size. The estimates are OLS estimates with robust standard
errors that accomodate residual heteroscedasticity.
}
\examples{
est <- c(4.1, 4.7, 4.9, 5.7, 6.6, 7.3)
se <- c(1.2, 1.5, 1.3, 1.8, 2.0, 2.6)
x1 <- c(10, 20, 30, 40, 50, 60)
x2 <- c(1, 1, 1, 0, 0, 0)
X <- matrix(cbind(x1, x2), 6, 2)
meta.lm.gen(.05, est, se, X)

# Should return:
#      Estimate         SE           z     p         LL         UL
# b0  3.5333333 4.37468253  0.80767766 0.419 -5.0408869 12.1075535
# b1  0.0600000 0.09058835  0.66233679 0.508 -0.1175499  0.2375499
# b2 -0.1666667 2.81139793 -0.05928249 0.953 -5.6769054  5.3435720


}
