% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.prop2}
\alias{meta.ave.prop2}
\title{Confidence interval for an average proportion difference in
2-group studies}
\usage{
meta.ave.prop2(alpha, f1, f2, n1, n2, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 event counts}

\item{f2}{vector of group 2 event counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate
across all studies.  If bystudy is true, there is 1 additional row for
each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average proportion difference from two or more studies.
}
\examples{
n1 <- c(204, 201, 932, 130, 77)
n2 <- c(106, 103, 415, 132, 83)
f1 <- c(24, 40, 93, 14, 5)
f2 <- c(12, 9, 28, 3, 1)
meta.ave.prop2(.05, f1, f2, n1, n2, bystudy = TRUE)

# Should return:
#             Estimate         SE            LL         UL
# Average 0.0567907589 0.01441216  2.854345e-02 0.08503807
# Study 1 0.0009888529 0.03870413 -7.486985e-02 0.07684756
# Study 2 0.1067323481 0.04018243  2.797623e-02 0.18548847
# Study 3 0.0310980338 0.01587717 -2.064379e-05 0.06221671
# Study 4 0.0837856174 0.03129171  2.245499e-02 0.14511624
# Study 5 0.0524199553 0.03403926 -1.429577e-02 0.11913568


}
\references{
\insertRef{Bonett2014}{vcmeta}
}
