% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_wordcloud}
\alias{v_wordcloud}
\title{Create a Wordcloud}
\usage{
v_wordcloud(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Wordcloud
}
\examples{

library(vchartr)

vchart(top_cran_downloads) \%>\%
  v_wordcloud(aes(word = package, count = count))

vchart(top_cran_downloads) \%>\%
  v_wordcloud(aes(word = package, count = count, color = package))

vchart(top_cran_downloads) \%>\%
  v_wordcloud(
    aes(word = package, count = count, color = package),
    wordCloudConfig = list(
      zoomToFit = list(
        enlarge = TRUE,
        fontSizeLimitMax = 30
      )
    )
  )
\donttest{

# Use an image to shape the wordcloud
vchart(top_cran_downloads) \%>\%
  v_wordcloud(
    aes(word = package, count = count, color = package),
    maskShape = "https://jeroen.github.io/images/Rlogo.png"
  )
  
}
}
