% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_heatmap}
\alias{v_heatmap}
\title{Create a Heatmap Chart}
\usage{
v_heatmap(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Heatmap Chart
}
\examples{

library(vchartr)

# Heatmap with continuous fill variable
vchart(co2_emissions) \%>\%
  v_heatmap(aes(x = year, y = country, fill = co2_per_capita))

# Change colors
vchart(co2_emissions) \%>\%
  v_heatmap(aes(x = year, y = country, fill = co2_per_capita)) \%>\%
  v_specs_colors(
    range = rev(
      c("#8C510A", "#BF812D", "#DFC27D", "#F6E8C3",
        "#C7EAE5", "#80CDC1", "#35978F", "#01665E")
    )
  )

# Heatmap with discrete fill variable
vchart(co2_emissions) \%>\%
  v_heatmap(aes(x = year, y = country, fill = co2_growth_change))

# Change colors
vchart(co2_emissions) \%>\%
  v_heatmap(aes(x = year, y = country, fill = co2_growth_change)) \%>\%
  v_scale_fill_manual(c(
    Increase = "firebrick",
    Decrease = "forestgreen"
  ))

}
