% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{vault_client_object}
\alias{vault_client_object}
\title{Base object type}
\description{
Base object type

Base object type
}
\details{
Base object used by vaultr for all objects
}
\examples{

server <- vaultr::vault_test_server(if_disabled = message)

if (!is.null(server)) {
  client <- vaultr::vault_client(addr = server$addr)
  client$operator$format()
  client$operator$format(TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{vault_client_object$new()}}
\item \href{#method-format}{\code{vault_client_object$format()}}
\item \href{#method-help}{\code{vault_client_object$help()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Construct an object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_object$new(description)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{Description for the object, will be printed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Format method, overriding the R6 default
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_object$format(brief = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{brief}}{Logical, indicating if this is the full format or
a brief (one line) format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-help"></a>}}
\if{latex}{\out{\hypertarget{method-help}{}}}
\subsection{Method \code{help()}}{
Display help for this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_object$help()}\if{html}{\out{</div>}}
}

}
}
