% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_ks.R
\name{gof_ks}
\alias{gof_ks}
\title{Kolmogorov-Smirnov goodness-of-fit test for the Vasicek distribution}
\usage{
gof_ks(x, Rho, P)
}
\arguments{
\item{x}{A numeric vector in the (0, 1) interval that is supposed to
follow the Vasicek distribution}

\item{Rho}{The Rho parameter in the Vasicek distribution}

\item{P}{The P parameter in the Vasicek distribution}
}
\value{
A list with statistical test result, including ks stat and p-value.
}
\description{
The function \code{gof_ks} performs Kolmogorov-Smirnov goodness-of-fit
test for the Vasicek distribution
}
\examples{
x <- vsk_rvs(100, Rho = 0.2, P = 0.1)
gof_ks(x, Rho = 0.2, P = 0.1)
}
