% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVC_selection.R
\name{SVC_selection_control}
\alias{SVC_selection_control}
\title{SVC Selection Parameters}
\usage{
SVC_selection_control(
  IC.type = c("BIC", "cAIC_BW", "cAIC_VB"),
  method = c("grid", "MBO"),
  r.lambda = c(1e-10, 10),
  n.lambda = 10L,
  n.init = 10L,
  n.iter = 10L,
  CD.conv = list(N = 20L, delta = 1e-06, logLik = TRUE),
  hessian = FALSE,
  adaptive = FALSE,
  parallel = NULL,
  optim.args = list()
)
}
\arguments{
\item{IC.type}{(\code{character(1)}) \cr
Select Information Criterion.}

\item{method}{(\code{character(1)}) \cr
Select optimization method for lambdas, i.e., shrinkage parameters.
Either model-based optimization (MBO, Bischl et al., 2017 <arXiv:1703.03373>) or over grid.}

\item{r.lambda}{(\code{numeric(2)}) \cr
Range of lambdas, i.e., shrinkage parameters.}

\item{n.lambda}{(\code{numeric(1)}) \cr
If grid method is selected, number of lambdas per side of grid.}

\item{n.init}{(\code{numeric(1)}) \cr
If MBO method is selected, number of initial values for surrogate model.}

\item{n.iter}{(\code{numeric(1)}) \cr
If MBO method is selected, number of iteration steps of surrogate models.}

\item{CD.conv}{(\code{list(3)}) \cr
List containing the convergence conditions, i.e.,
first entry is the maximum number of iterations,
second value is the relative change necessary to stop iteration,
third is logical to toggle if relative change in log likelihood
(\code{TRUE}) or rather the parameters themselves (\code{FALSE})
is the criteria for convergence.}

\item{hessian}{(\code{logical(1)}) \cr
If \code{TRUE}, Hessian will be computed for final model.}

\item{adaptive}{(\code{logical(1)}) \cr
If \code{TRUE}, adaptive LASSO is executed, i.e.,
the shrinkage parameter is defined as \eqn{\lambda_j := \lambda / |\theta_j|}.}

\item{parallel}{(\code{list}) \cr
List with arguments for parallelization,
see documentation of \code{\link[optimParallel]{optimParallel}}.}

\item{optim.args}{(\code{list}) \cr
List of further arguments of \code{\link[optimParallel]{optimParallel}},
such as the lower bounds.}
}
\value{
A list of control parameters for SVC selection.
}
\description{
Function to set up control parameters for
   \code{\link{SVC_selection}}. The underlying Gaussian Process-based
   SVC model is defined in \code{\link{SVC_mle}}. \code{\link{SVC_selection}}
   then jointly selects fixed and random effects of the GP-based
   SVC model using a penalized maximum likelihood estimation (PMLE).
   In this function, one can set the parameters for the PMLE and
   its optimization procedures (Dambon et al., 2021, <arXiv:2101.01932>).
}
\examples{
# Initializing parameters and switching logLik to FALSE
selection_control <- SVC_selection_control(
  CD.conv = list(N = 20L, delta = 1e-06, logLik = FALSE)
)
# or
selection_control <- SVC_selection_control()
selection_control$CD.conv$logLik <- FALSE

}
\references{
Bischl, B., Richter, J., Bossek, J., Horn, D., Thomas, J., Lang, M. (2017).
   \emph{mlrMBO: A Modular Framework for Model-Based Optimization of Expensive Black-Box Functions},
   ArXiv preprint \url{https://arxiv.org/abs/1703.03373}

   Dambon, J. A., Sigrist, F., Furrer, R. (2021)
   \emph{Joint Variable Selection of both Fixed and Random Effects for Gaussian
   Process-based Spatially Varying Coefficient Models},
   ArXiv preprint \url{https://arxiv.org/abs/2101.01932}
}
\author{
Jakob Dambon
}
