% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pen_functions.R
\name{SCAD}
\alias{SCAD}
\title{Smoothly Clipped Absolute Deviation Penalty}
\usage{
SCAD(x, lambda = 1, a = 3.7)
}
\arguments{
\item{x}{numeric.}

\item{lambda}{non-negative scalar, shrinkage parameter.}

\item{a}{scalar larger than 2. Fan & Li (2001) suggest \eqn{a = 3.7}.}
}
\value{
penalty for values of \code{x}.
}
\description{
Penalty function proposed by Fan & Li (2001) \doi{10.1198/016214501753382273}.
}
\examples{

SCAD(-5:5)
curve(SCAD, from = -5, to = 5)
}
\references{
Jianqing Fan & Runze Li (2001) Variable Selection via Nonconcave Penalized Likelihood and its Oracle Properties, Journal of the American Statistical Association, 96:456, 1348-1360, \doi{10.1198/016214501753382273}
}
\author{
Jakob Dambon
}
