"irf.vec2var" <-
function(x, impulse=NULL, response=NULL, n.ahead=10, ortho=TRUE, cumulative=FALSE, boot=TRUE, ci=0.95, runs=100, seed=NULL, ...){
  if(!(class(x)=="vec2var")){
    stop("\nPlease provide an object of class 'vec2var', generated by 'vec2var()'.\n")
  }
  y.names <- colnames(x$y)
  if(is.null(impulse)){
    impulse <- y.names
  } else {
    impulse <- as.vector(as.character(impulse))
    if(any(!(impulse %in% y.names))) {
      stop("\nPlease provide variables names in impulse\nthat are in the set of endogenous variables.\n")
    }
    impulse <- subset(y.names, subset = y.names %in% impulse)
  }
  if(is.null(response)){
    response <- y.names
  } else {
    response <- as.vector(as.character(response))
    if(any(!(response %in% y.names))){
      stop("\nPlease provide variables names in response\nthat are in the set of endogenous variables.\n")
    }
    response <- subset(y.names, subset = y.names %in% response)
  }
  ## Getting the irf
  irs <- .irf(x = x, impulse = impulse, response = response, y.names = y.names, n.ahead = n.ahead, ortho = ortho, cumulative = cumulative)
  ## Bootstrapping
  Lower <- NULL
  Upper <- NULL
  if(boot){
    ci <- as.numeric(ci)
    if((ci <= 0)|(ci >= 1)){
      stop("\nPlease provide a number between 0 and 1 for the confidence interval.\n")
    }
    ci <- 1 - ci
    if(!(is.null(seed))) set.seed(abs(as.integer(seed)))
    Zdet <- matrix(x$datamat[ , colnames(x$deterministic)], ncol = ncol(x$deterministic))
    B <- x$deterministic
    for(i in 1:x$p){
      B <- cbind(B, x$A[[i]])
    }
    p <- x$p
    K <- x$K
    obs <- x$obs
    total <- x$totobs
    assign("spec", x$vecm@call$spec, env = .GlobalEnv)
    assign("spec", match.arg(spec, c("transitory", "longrun")), env = .GlobalEnv)
    assign("Kendog", x$vecm@call$K, env = .GlobalEnv)
    assign("constant", x$vecm@call$constant, env = .GlobalEnv)
    assign("season", x$vecm@call$season, env = .GlobalEnv)
    assign("dumvar", x$vecm@call$dumvar, env = .GlobalEnv)
    BOOT <- list()
    ysampled <- matrix(0, nrow = total, ncol = K)
    colnames(ysampled) <- colnames(x$y)
    resorig <- scale(x$resid, scale = FALSE)
    for(i in 1:runs){
      booted <- sample(c(1 : obs), replace=TRUE)
      resid <- resorig[booted, ]
      lasty <- c(t(x$y[p : 1, ]))
      ysampled[c(1 : p), ] <- x$y[c(1 : p), ]
      for(j in 1 : obs){
        lasty <- lasty[1 : (K * p)]
        Z <- c(Zdet[j, ], lasty)
        ysampled[j + p, ] <- B %*% Z + resid[j, ]
        lasty <- c(ysampled[j + p, ], lasty)
      }
      vec <- ca.jo(ysampled, constant = get("constant"), season = get("season"), dumvar = get("dumvar"), spec = get("spec"), K = get("Kendog"))
      varboot <- vec2var(vec, r = x$call$r)
      BOOT[[i]] <- .irf(x = varboot, n.ahead = n.ahead, ortho = ortho, cumulative = cumulative, impulse = impulse, response = response, y.names = y.names)
    }
    rm(constant, season, dumvar, spec, Kendog, envir = .GlobalEnv)
    lower <- ci / 2
    upper <- 1 - ci / 2
    mat.l <- matrix(NA, nrow = n.ahead + 1, ncol = length(response))
    mat.u <- matrix(NA, nrow = n.ahead + 1, ncol = length(response))
    Lower <- list()
    Upper <- list()
    idx1 <- length(impulse)
    idx2 <- length(response)
    idx3 <- n.ahead + 1
    temp <- rep(NA, runs)
    for(j in 1 : idx1){
      for(m in 1 : idx2){
        for(l in 1 : idx3){
          for(i in 1 : runs){
            if(idx2 > 1){
              temp[i] <- BOOT[[i]][[j]][l, m]
            } else {
              temp[i] <- matrix(BOOT[[i]][[j]])[l, m]
            }
          }
          mat.l[l, m] <- quantile(temp, lower)
          mat.u[l, m] <- quantile(temp, upper)
        }
      }
      colnames(mat.l) <- response
      colnames(mat.u) <- response
      Lower[[j]] <- mat.l
      Upper[[j]] <- mat.u
    }
    names(Lower) <- impulse
    names(Upper) <- impulse
    BOOT <- list(Lower = Lower, Upper = Upper)
    Lower <- BOOT$Lower
    Upper <- BOOT$Upper
  }
  result <- list(irf=irs, Lower=Lower, Upper=Upper, response=response, impulse=impulse, ortho=ortho, cumulative=cumulative, runs=runs, ci=ci, boot=boot, model = class(x))
  class(result) <- "varirf"
  return(result)
}
