% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcdina_vb.R
\name{mc_dina_data_gen}
\alias{mc_dina_data_gen}
\title{the artificial data generation for the multiple-choice DINA model based on the given Q-matrix
\code{mc_dina_data_gen()} returns the artificially generated item response data for the MC-DINA model}
\usage{
mc_dina_data_gen(I, Q, att_cor = 0.1, seed = 1234)
}
\arguments{
\item{I}{the number of assumed respondents}

\item{Q}{the J by K binary matrix}

\item{att_cor}{the true value of the correlation among attributes (default: 0.1)}

\item{seed}{the seed value used for random number generation (default: 1234)}
}
\value{
A list including:
\describe{
  \item{X}{the generated artificial item response data}
  \item{att_pat}{the generated true vale of the attribute mastery pattern}
}
}
\description{
the artificial data generation for the multiple-choice DINA model based on the given Q-matrix
\code{mc_dina_data_gen()} returns the artificially generated item response data for the MC-DINA model
}
\examples{
# load a simulated Q-matrix
mc_Q = mc_sim_Q
mc_sim_data = mc_dina_data_gen(Q=mc_Q,I=200)

}
\references{
Yamaguchi, K. (2020). Variational Bayesian inference for the
  multiple-choice DINA model. \emph{Behaviormetrika}, 47(1), 159-187.
  \doi{10.1007/s41237-020-00104-w}
}
