% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImpRanger.R
\name{varImpRanger}
\alias{varImpRanger}
\title{varImpRanger}
\usage{
varImpRanger(object, data, target, nperm = 1,
  measure = "multiclass.Brier")
}
\arguments{
\item{object}{An object as returned by cforest. \code{\link[ranger]{ranger}} with option \code{keep.inbag = TRUE}.}

\item{data}{Original data that was used for training the random forest.}

\item{target}{Target variable as used in the trained model.}

\item{nperm}{The number of permutations performed.}

\item{measure}{The name of the measure of the 'measures' package that should be used for the variable importance calculation.}
}
\value{
Vector with computed permutation importance for each variable.
}
\description{
Computes the variable importance for ranger models and for arbitrary measures from the 'measures' package.
}
\examples{
\dontrun{
library(ranger)
iris.rg = ranger(Species ~ ., data = iris, keep.inbag = TRUE, probability = TRUE)
vimp.ranger = varImpRanger(object = iris.rg, data = iris, target = "Species")
vimp.ranger
}
}
