% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata.plm.margins.R
\name{stata.plm.margins}
\alias{stata.plm.margins}
\title{Simplified STATA Predictive Margins}
\usage{
stata.plm.margins(mod, plot = FALSE, error = NULL)
}
\arguments{
\item{mod}{a plm model object.}

\item{plot}{logical (default set to \code{FALSE}). When set to \code{plot = TRUE}, will return a an margins plot of the interaction terms.}

\item{error}{the number standard deviation units for which the margins will be calculated (default set to 2).}
}
\value{
This function creates a data frame of predictive margins for the dependent variable, given values of the variables in the interaction.
}
\description{
This function returns a data frame with interactive margins and standard errors similar to those returned in the STATA margins call. The function can also return a margins plot.
}
\examples{
library(plm)
data <- UCR2015
summary(mod <- plm(dui_pct ~ pct_poverty*pct_unemp +
income_inequality, data=data, index=c("state","county"),
model="within"))

stata.plm.margins(mod)
}
