% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ideo.dist.R
\name{ideo.dist}
\alias{ideo.dist}
\title{Calculating Ideological Distance}
\usage{
ideo.dist(df, id, ideology, time, adoption)
}
\arguments{
\item{df}{data frame to read in. This should be an adapted version of the \code{Ideology} data set provided in the package. The adapted version should include an outcome variable measuring the policy adoption of choice.}

\item{id}{the grouping variable, usually states}

\item{ideology}{the state's ideology score variable (either \emph{state} or \emph{citizen} ideology) in a given year. These data come from Richard C. Fording (\url{https://rcfording.com/state-ideology-data/}) as used in Berry et al. (1998), and are measured, for each state, from 1960 to 2018.}

\item{time}{the time variable, at which the ideology score is measured. These data come from Richard C. Fording (\url{https://rcfording.com/state-ideology-data/}) as used in Berry et al. (1998), and are measured, for each state, from 1960 to 2018.}

\item{adoption}{binary, user-defined measure of the status of policy adoption in a state in a given year. \code{0} equates to \emph{policy not adopted in the year, for the state}, \code{1} equates to\emph{policy is adopted in the year, for the state} -- a value of \code{1} should only exist for a state in the year it was adopted (e.g. not every year thereafter). The example below relies on ERA ratification data from Soule and King (2006), but the user should include the measure of adoption of their choice.}
}
\description{
This function calculates ideological distance scores based on the calculation created by Grossback et al. (2004) and clarified by Cruz-Aceves and Mallinson (2019). This calculation is based on state ideology data (by year) provided by Richard C. Fording (\url{https://rcfording.com/state-ideology-data/}) and used in Berry et al. (1998). This function can be applied to any unit of analysis and time level for any type of policy adoption.
}
\examples{
data <- Ideology_ERA

ideo.dist(data, state, s_ideo, year, era_status)
}
