% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlignOverlap.R
\name{CalcAlignOverlap}
\alias{CalcAlignOverlap}
\title{Calculate Alignment Overlap}
\usage{
CalcAlignOverlap(ref.num.atoms, ref.ca, ref.idc, soi.PDB, CA.dist)
}
\arguments{
\item{ref.num.atoms}{Number of atoms in the reference structure}

\item{ref.ca}{PDB formatted \code{data.frame} containing only C-alpha atoms}

\item{ref.idc}{The indices of the reference structure atoms; from \code{1} to the
number of atoms in the reference structure}

\item{soi.PDB}{The structure of interest (SoI) being compared to the
reference structure. This is the full PDB structure read into \code{R} using the
\code{\link[bio3d:read.pdb2]{bio3d::read.pdb2()}} function}

\item{CA.dist}{The minimum distance between C-alpha atoms for the two C-alpha
atoms to be considered aligned; default: 1.25}
}
\value{
This function returns:
\itemize{
\item \strong{ratio.intersection}: fraction of SOI overlapping with the reference structure
\item \strong{soi.chain}: Chain letter designations for the aligned SOI
\item \strong{soi.chain.overlap}: Unique chain letter designations for the aligned SOI
These values are then used within the \code{\link[=AlignOverlap]{AlignOverlap()}} function to determine
if the structures are adequately aligned.
}
}
\description{
Calculate the amount of alignment overlap between two protein
structures using C-alpha atoms.
}
\details{
Using the C-alpha atoms of two aligned proteins, the amount of
atomic overlap is determined. This function is within the \link{AlignOverlap}
function.

This is a \emph{\strong{non-public}} function and is \emph{\strong{NOT}} available for general
use. Please contact the author if you believe this function should be
available for general use.
}
\seealso{
Other "Alignment Overlap": \code{\link{AlignOverlap}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
