% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ReturnPDBfullPath}
\alias{ReturnPDBfullPath}
\title{Return PDB Full Path}
\usage{
ReturnPDBfullPath(prefix)
}
\arguments{
\item{prefix}{The directory with the PDB files of interest; \emph{e.g.},
ProteinSystem_Aligned}
}
\value{
collection of string values with the complete (normalized) path for
each PDB file within the provided directory/folder.
}
\description{
Determine the full path of the PDB files and return the complete
path of each file within the provided directory.
}
\details{
The complete path of the PDB file(s) in the user provided
\code{prefix} is returned.

\emph{\strong{NOTE}}: This is a non-public function.
}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
