% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deming_methods.R
\name{summary.deming_regression}
\alias{summary.deming_regression}
\title{Summary method for deming_regression objects}
\usage{
\method{summary}{deming_regression}(object, ...)
}
\arguments{
\item{object}{An object of class \code{deming_regression}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns a list with summary statistics.
}
\description{
Provides a detailed summary of Deming regression results, including
regression coefficients, confidence intervals, standard errors,
and interpretation guidance.
}
\details{
The summary includes:
\itemize{
\item Regression coefficients with standard errors and confidence intervals
\item Interpretation of slope and intercept CIs
\item Method agreement conclusion
\item Residual summary statistics
}
}
\examples{
set.seed(42)
true_vals <- rnorm(50, 100, 20)
method_a <- true_vals + rnorm(50, sd = 5)
method_b <- 1.05 * true_vals + 3 + rnorm(50, sd = 5)
dm <- deming_regression(method_a, method_b)
summary(dm)

}
\seealso{
\code{\link[=print.deming_regression]{print.deming_regression()}} for concise output
}
