% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_methods.R
\name{summary.pb_regression}
\alias{summary.pb_regression}
\title{Summary method for pb_regression objects}
\usage{
\method{summary}{pb_regression}(object, ...)
}
\arguments{
\item{object}{An object of class \code{pb_regression}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns a list with summary statistics.
}
\description{
Provides a detailed summary of Passing-Bablok regression results, including
regression coefficients, confidence intervals, linearity test (CUSUM),
and interpretation guidance.
}
\details{
The summary includes:
\itemize{
\item Regression coefficients with confidence intervals
\item CUSUM test for linearity assumption
\item Interpretation of slope and intercept CIs
\item Method agreement conclusion
}
}
\examples{
set.seed(42)
method_a <- rnorm(50, mean = 100, sd = 15)
method_b <- 1.05 * method_a + 3 + rnorm(50, sd = 5)
pb <- pb_regression(method_a, method_b)
summary(pb)

}
\seealso{
\code{\link[=print.pb_regression]{print.pb_regression()}} for concise output
}
