% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_reldist.r
\name{bed_reldist}
\alias{bed_reldist}
\title{Compute relative distances between intervals.}
\usage{
bed_reldist(x, y, detail = FALSE)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{y}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{detail}{report relative distances for each \code{x} interval.}
}
\value{
If \code{detail = FALSE}, a \code{\link[=tbl_interval]{tbl_interval()}} that summarizes
calculated \code{.reldist} values with the following columns:
\itemize{
\item \code{.reldist} relative distance metric
\item \code{.counts} number of metric observations
\item \code{.total} total observations
\item \code{.freq} frequency of observation
}

If \code{detail = TRUE}, the \code{.reldist} column reports the relative
distance for each input \code{x} interval.
}
\description{
Compute relative distances between intervals.
}
\details{
Interval statistics can be used in combination with
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:do]{dplyr::do()}} to calculate
statistics for subsets of data. See \code{vignette('interval-stats')} for
examples.
}
\examples{
genome <- read_genome(valr_example('hg19.chrom.sizes.gz'))

x <- bed_random(genome, seed = 1010486)
y <- bed_random(genome, seed = 9203911)

bed_reldist(x, y)

bed_reldist(x, y, detail = TRUE)

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/reldist.html}

Other interval statistics: \code{\link{bed_absdist}},
  \code{\link{bed_fisher}}, \code{\link{bed_jaccard}},
  \code{\link{bed_projection}}
}
