% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utr_analysis.R
\name{getTranscriptIdsForOneCodonVariant}
\alias{getTranscriptIdsForOneCodonVariant}
\title{Find the ensembl_transcript_id and codon postions for one variant}
\usage{
getTranscriptIdsForOneCodonVariant(
  variant,
  transcriptRegions,
  checkRegion,
  start,
  end
)
}
\arguments{
\item{variant}{one row of variants table}

\item{transcriptRegions}{transcripts structure table from ensembl}

\item{checkRegion}{check if a transcript within a region stopCodon or startCodon}

\item{start}{column name of the start region of checkRegion in transcripts structure table}

\item{end}{column name of the end region of checkRegion in transcripts structure table}
}
\value{
A data table containing two columns: ensembl_transcript_id (id of transcripts for each variant which its mutation Pos is within those transcripts checkRegion.)
                                       codon_positions (positions of each nucleotides in the codon)
}
\description{
Find the ensembl_transcript_id and codon postions for one variant
}
\details{
For each variant, get all transcripts and extract their checkRegion's coordinates. For each transcript, check if the mutation Pos
is within the region, if so, add that transcript's ensembl_transcript_id. If the mutation Pos is within multiple transcripts checkRegions,
the transcripts ids are concatenate into one string with ";".
}
\keyword{internal}
