% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_event_row.R
\name{build_event_row}
\alias{build_event_row}
\title{build_event_row}
\usage{
build_event_row(.table = NULL, label = NULL, col = NULL,
  fit = NULL, percent.sign = TRUE, digits = 1, p.digits = 4,
  indent = FALSE)
}
\arguments{
\item{.table}{Optional. Tibble. A tibble for row to be appended.}

\item{label}{Optional. Character. Row name to print in the table. Defaults to value of \'col\' parameter.}

\item{col}{Required. Character. Name of column used as a parameter in the tiem-to-event function.}

\item{fit}{Required. survival::coxph().}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round numerics to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of digits to print for p-value. Note that p-values are still
rounded based on the \'digits\' parameter. Defaults to 4.}

\item{indent}{Optional. Logical. Indent a variable labels. Defaults to FALSE.}
}
\value{
Data is returned in the form of a tibble containing a row for the specified parameter.
}
\description{
Creates a tibble row summarizing a predictor (column) in a given time-to-event model.
}
\examples{
library(survival)
library(dplyr)

data_lung <- lung \%>\%
  as_tibble() \%>\%
  mutate_at(vars(inst, status, sex), as.factor) \%>\%
  mutate(status = case_when(status == 1 ~ 0, status == 2 ~ 1))

# Stand-alone row
build_event_row(
   label = 'Meal calories',
   col = 'meal.cal',
   fit = coxph(Surv(time, status) ~ meal.cal, data = data_lung)
)

# Build a table row-by-row
build_event_row(
  label = 'Age, years',
  col = 'age',
  fit = coxph(Surv(time, status) ~ age, data = data_lung)
) \%>\%
build_event_row(
  label = 'Sex',
  col = 'sex',
  fit = coxph(Surv(time, status) ~ sex, data = data_lung)
) \%>\%
build_event_row(
  label = 'Institution',
  col = 'inst',
  fit = coxph(Surv(time, status) ~ inst, data = data_lung)
)
}
