% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_na.R
\name{use_na}
\alias{use_na}
\title{Use NA of different classes in your project}
\usage{
use_na(path = "R", export = TRUE)
}
\arguments{
\item{path}{(\code{character}) A path pointing at where to copy the file.}

\item{export}{If \code{TRUE}, the file content is exported to \code{NAMESPACE}.}
}
\value{
No return value, called for side effects.
}
\description{
R has several built-in NA values that correspond to the atomic
data types, such as \code{NA} (logical), \code{NA_integer_} and \code{NA_character_}.
Calling \code{use_na()} allows the programmer to have NA values of any class. In
addition, \code{use_na()} provides several useful NA values such as \code{NA_list_},
\code{NA_Date_} and \code{NA_POSIXct_}.
}
\details{
The function copies a file with several NA values to
'\code{path}/utils-na.R'.
}
\examples{
path <- tempfile()
use_na(path)
print(readLines(file.path(path, "utils-na.R")))

}
