% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.r
\name{indexToPosition}
\alias{indexToPosition}
\title{indexToPosition}
\usage{
indexToPosition(x, nrow = 1)
}
\arguments{
\item{x}{Position of indices}

\item{nrow}{The number of rows in the matrix}
}
\value{
A Matrix with row and column columns and a row for each value of \code{x}
}
\description{
Given a long matrix index convert to row and column positions
}
\details{
Using \code{\link{which}} on a matrix returns a number that iterates down rows then across columns.  This function returns the (row, column) position of that index.
}
\examples{
indexToPosition(3, 2)
indexToPosition(c(1, 4, 5, 7, 9), 3)
indexToPosition(1:16, 4)
indexToPosition(c(1, 3, 5, 6, 8, 10, 11, 13, 15), 5)

}
\author{
Jared P. Lander
}

