% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_retrieve_bitlinks_by_groups}
\alias{bitly_retrieve_bitlinks_by_groups}
\title{Retrieve Bitlinks by Group}
\usage{
bitly_retrieve_bitlinks_by_groups(
  group_guid = NULL,
  size = 50,
  page = 1,
  showRequestURL = FALSE,
  keyword = NULL,
  query_q = NULL,
  created_before = NULL,
  created_after = NULL,
  modified_after = NULL,
  archived = "both",
  deeplinks = "both",
  campaign_guid = NULL,
  channel_guid = NULL,
  custom_bitlink = "both",
  tags = NULL,
  encoding_login = NULL,
  domain_deeplinks = "both"
)
}
\arguments{
\item{group_guid}{- a GUID for a Bitly group}

\item{size}{- The quantity of items to be be returned}

\item{page}{- Default: 1 | Integer specifying the numbered result at which to start}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug
purposes.}

\item{keyword}{- Custom keyword to filter on history entries}

\item{query_q}{- a query to look for in bitlinks; acts a filter}

\item{created_before}{- Timestamp as an integer unix epoch}

\item{created_after}{- Timestamp as an integer unix epoch}

\item{modified_after}{- Timestamp as an integer unix epoch,
see \code{\link[lubridate]{as_datetime}} or \code{anytime}'s \code{as_datetime}}

\item{archived}{- string | Default: "off" | Enum:"on" "off" "both" | Whether or not to include archived bitlinks}

\item{deeplinks}{- string | Default: "both" | Enum:"on" "off" "both" | Filter to only Bitlinks that contain deeplinks}

\item{campaign_guid}{- string | A GUID for a Bitly campaign}

\item{channel_guid}{- Filter to return only links for the given channel GUID,
can be provided, overrides all other parameters}

\item{custom_bitlink}{- string | Default: "both" | Enum:"on" "off" "both"}

\item{tags}{- Array of string, use e.g. \code{c("test1", "test2")}}

\item{encoding_login}{- Array of string | Filter by the login of the authenticated user that created the Bitlink}

\item{domain_deeplinks}{- string | Default: "both" | Enum:"on" "off" "both" | Filter to only Bitlinks
that contain deeplinks configured with a custom domain}
}
\description{
See \url{https://dev.bitly.com/api-reference#getBitlinksByGroup}
Retrieve a paginated collection of Bitlinks for a Group
}
\examples{
\dontrun{
bitly_retrieve_bitlinks_by_groups(group_guid = "bit.ly/DPetrov", keyword = "novy titulek")
}
}
