## ------------------------------------------------------------------------
t1 = Sys.time() 
t2 = t1 + 3600 
d = t2 - t1
class(d)
units(d)
d
units(d) = "secs"
d

## ------------------------------------------------------------------------
library(units)
(a = as.units(1:10, "m/s"))

## ------------------------------------------------------------------------
b = a
units(b) = "km/h"
b

## ------------------------------------------------------------------------
x = try(units(a) <- "secs")
x

## ------------------------------------------------------------------------
a + a
a * a
a ^ 2.5

## ------------------------------------------------------------------------
a + b # m/s + km/h -> m/s

## ------------------------------------------------------------------------
t = as.units(1, "s")
a * t

## ------------------------------------------------------------------------
signif(a^2.5, 3)
cumsum(a)

## ------------------------------------------------------------------------
sum(a)
min(a)
max(a)
range(a)
min(as.units(1, "m/s"), as.units(1, "km/h")) # converts to first unit:

## ------------------------------------------------------------------------
a
a[1]

## ------------------------------------------------------------------------
a[2:5]
a[-(1:9)]

## ------------------------------------------------------------------------
c(a,a)

## ------------------------------------------------------------------------
c(a,b) # m/s, km/h -> m/s
c(b,a) # km/h, m/s -> km/h

## ------------------------------------------------------------------------
t1 = Sys.time() 
t2 = t1 + 3600 
d = t2 - t1
as.units(d)
(du = as.units(d, "d"))

## ------------------------------------------------------------------------
dt = as.dt(du)
class(dt)
dt

## ------------------------------------------------------------------------
as.units(matrix(1:4,2,2), "m/s")
as.units(matrix(1:4,2,2), "m/s") * as.units(4, "m/s")

## ------------------------------------------------------------------------
as.units(matrix(1:4,2,2), "m/s") %*% as.units(4:3, "m/s")

## ------------------------------------------------------------------------
set.seed(131)
d = data.frame(x = runif(4), y = as.units(runif(4), "s"), z = as.units(1:4, "m/s"))
d
summary(d)
d$yz = with(d, y * z)
d
d[1, "yz"]

