% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygon.R
\name{runif_in_polygon}
\alias{runif_in_polygon}
\title{Uniform sampling in a polygon}
\usage{
runif_in_polygon(n, vertices, center = "centroid")
}
\arguments{
\item{n}{number of simulations}

\item{vertices}{two-columns matrix giving the vertices (rows); the vertices
must be ordered (clockwise or counterclockwise)}

\item{center}{a point with respect to which the polygon is star-shaped, or
\code{"centroid"} (default) to take the centroid (see Details)}
}
\value{
The simulations in a \code{n} times \code{2} matrix.
}
\description{
Uniform sampling in a polygon (dimension 2).
}
\details{
This function works for a star-shaped polygon, that is, a polygon
that contains a point from which the entire polygon boundary is visible.
This point must be given in the \code{center} argument. If the polygon is
convex, any point inside the polygon is suitable (thus the default option
of the \code{center} argument is appropriate in this case).
}
\examples{
vs <- matrix(c(0.951056516295154, 0.309016994374947,
               0.224513988289793, 0.309016994374947,
               -0.951056516295154, 0.309016994374948,
               -0.363271264002681, -0.118033988749895,
               0.587785252292473, -0.809016994374948,
               0.36327126400268, -0.118033988749895,
               0, 1,
               -0.224513988289793, 0.309016994374947,
               -0.587785252292473, -0.809016994374947,
               0, -0.381966011250105),
             ncol=2, byrow=TRUE)
sims <- runif_in_polygon(500, vs)
plot(sims, xlim=c(-1,1), ylim=c(-1,1), pch=19, asp=1)
}
