% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_asset.R
\name{import_asset}
\alias{import_asset}
\title{Import assets into Unity.}
\usage{
import_asset(script, asset_path, lazy = TRUE)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{asset_path}{The file path to the asset to import. If a directory, the
entire directory will be recursively copied. Note that this function doesn't
have a \code{method_name} argument: the \code{asset_path} is used as the method name.
This function is not currently vectorized; call it separately for each asset
you need to import.}

\item{lazy}{Boolean: if TRUE, unifir will attempt to only copy the files
once per run of a script; if FALSE, unifir will copy the files as many times
as requested, overwriting pre-existing files each time.}
}
\value{
\code{script} with a new prop.
}
\description{
Import assets into Unity.
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script",
  unity = waiver()
)

# CRAN also doesn't have any props to install,
# so we'll make a fake prop location:
prop_directory <- file.path(tempdir(), "props")
dir.create(prop_directory)

# Now add props:
script <- import_asset(script, prop_directory)

# Lastly, execute the script via the `action` function
}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_light}()},
\code{\link{add_prop}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}
}
\concept{props}
