% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirwin.hall.R
\name{dirwin.hall}
\alias{dirwin.hall}
\title{Irwin-Hall density}
\usage{
dirwin.hall(x, n, log = FALSE)
}
\arguments{
\item{x}{A number between 0 and \code{n}.}

\item{n}{Number of uniform distributions in the unit interval to sum.}

\item{log}{If it evaluates to \code{TRUE} it returns the log of the
density instead of the density.}
}
\description{
Irwin-Hall density
}
\details{
Gives the density of the Irwin-Hall distribution. It is
    the density of the sum of \code{n} uniform distributions on the
    interval (0,1).

\deqn{
  h(y;n) = \frac{1}{(n-1)!}\sum_{k=0}^{ \left\lfloor y \right\rfloor } (-1)^k {n \choose k} (y-k)^{n-1}
}{
                1       __ |_y_|       k /  n \         n - 1 
h(y;n)  =  ---------  \         ( - 1)   |    |  (y - k)      
            (n - 1)!  /__ k = 0          \ k  /               
}

where \eqn{x \in [0,1]} and \eqn{n} is a positive integer.

This function is not numerically stable. The examples have some cases of this.
}
\examples{

dirwin.hall(2,5)

# Numerically unstable example
# Run the following one after the other
# See how it goes from positive to negative (which means overflowing )
dirwin.hall(35,50)
dirwin.hall(36,50)
dirwin.hall(37,50)
dirwin.hall(38,50)

}
