% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copenhagen.R
\docType{data}
\name{ku_1}
\alias{ku_1}
\title{Primary colours of the University of Copenhagen, Denmark}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on \href{https://www.ku.dk}{KU}'s 
\href{https://designguide.ku.dk/om_design/logo_og_farve/farver/}{design guide} (HTML).
}
\usage{
ku_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ku_1} provides the two primary colours 
of the \href{https://www.ku.dk}{University of Copenhagen}, Denmark.
}
\details{
The 2 primary colours are 
\code{KU red}, defined as 
CMYK-U: 0 100 65 34, CMYK-C: 25 100 77 40, 
Pantone-U p 201, Pantone-C p 188, 
RGB 144 26 30, HEX "#901A1E", or Textil 19-1934 TP, 
and 
\code{KU grey}, defined as 
CMYK-U/C 0 0 0 70, Pantone-U/C p 431, 
RGB 102 102 102, HEX "#666666", or Textil 17-1501 TP.

\code{ku_1} is based on HEX color definitions.
}
\examples{
ku_1
unikn::seecol(ku_1, 
              main = "Primary colours of the University of Copenhagen, DK")  # view palette
              
}
\seealso{
\code{\link{ku_2}} for secondary colours of the University of Copenhagen;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Danish university color palettes: 
\code{\link{aarhus}},
\code{\link{ku_2}}
}
\author{
\strong{unicol}, 2023-10-13.
}
\concept{Danish university color palettes}
\keyword{datasets}
