% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uppsala.R
\docType{data}
\name{uppsala}
\alias{uppsala}
\title{Colours of Uppsala University, Sweden}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\href{https://www.uu.se}{Uppsala}'s 
\href{https://mp.uu.se/en/web/info/stod/kommunikation-riktlinjer/visuellariktl/profilfarger}{visual identity guidelines} (HTML).
}
\usage{
uppsala
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uppsala} provides the colours  
of \href{https://www.uu.se}{Uppsala University}, Sweden.
}
\details{
The primary \code{Uppsala red} colour must not be tinted and must always be reproduced at 100\%.

The grey colors are reproduced in in different percentages of black (5–90\%). 
If a grey border is used, it may only be reproduced in 10\% black.

\code{uppsala} is based on RGB color definitions 
(except for \code{Digital grey}, which is defined as HEX "#CCCCCC").
}
\examples{
uppsala
unikn::seecol(uppsala, main = "The colours of Uppsala University, Sweden")  # view palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Swedish university color palettes: 
\code{\link{gothenburg}},
\code{\link{lund_1}},
\code{\link{lund_2}},
\code{\link{lund_3}},
\code{\link{stockholm_1}},
\code{\link{stockholm_2}}
}
\author{
\strong{unicol}, 2023-10-12.
}
\concept{Swedish university color palettes}
\keyword{datasets}
