% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFU.R
\docType{data}
\name{sfu_brand}
\alias{sfu_brand}
\title{Brand colours of Simon Fraser University, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on SFU's 
\href{https://www.sfu.ca/communicators-toolkit/guides/brand-guide/colours.html}{Brand guide}.
}
\usage{
sfu_brand
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{sfu_brand} provides the brand colours 
of \href{https://www.sfu.ca/}{Simon Fraser University}, Canada.
}
\details{
The primary colour is 
\code{"light_red"} (defined as HEX #CC0633 or RGB R204/G6/B51). 
The 3 secondary colours are 
\code{"dark_red"} (defined as HEX #A6192E or RGB R166/G25/B46),
\code{"dark_grey"} (defined as HEX #54585A or RGB R84/G88/B90), and
\code{"black"} (defined as HEX #000000 or RGB R0/G0/B0).

SFU light red is our primary colour, to be used as the dominant colour in all applications. 
It is supported by SFU dark red which is the colour used in the institutional logo. 
These two reds are designed to work well together, creating a distinctive tone-on-tone effect. 

SFU dark grey is simply used in the text portion of our academic unit and extension logos, 
and can be applied to subheads and graphic elements. Black is used for body copy.
}
\examples{
sfu_brand
unikn::seecol(sfu_brand, main = "SFU brand colours") # view colour palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
