# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' compute Euclidean distance between two vectors
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return euclidean norm of x-y
dEuclidean <- function(x, y) {
    .Call('_umap_dEuclidean', PACKAGE = 'umap', x, y)
}

#' compute Euclidean distances
#'
#' @keywords internal
#' @param m matrix with raw data
#' @param origin index (1-based) of origin element
#' @param targets indexes (1-based) of target elements
#'
#' @return dEuclidean norms between origin and target elements
mdEuclidean <- function(m, origin, targets) {
    .Call('_umap_mdEuclidean', PACKAGE = 'umap', m, origin, targets)
}

#' compute Manhattan distance between two vectors
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return manhattan norm of x-y
dManhattan <- function(x, y) {
    .Call('_umap_dManhattan', PACKAGE = 'umap', x, y)
}

#' compute Manhattan distances
#'
#' @keywords internal
#' @param m matrix with raw data
#' @param origin index (1-based) of origin element
#' @param targets indexes (1-based) of target elements
#'
#' @return dManhattan norms between origin and targets
mdManhattan <- function(m, origin, targets) {
    .Call('_umap_mdManhattan', PACKAGE = 'umap', m, origin, targets)
}

#' compute pearson correlation distance between two vectors
#'
#' Pearson distance is (1-r^2)
#'
#' Important: this function assumes that data has been centered
#' i.e. that mean(x) = mean(y) = 0
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return pearson distance between x and y
dCenteredPearson <- function(x, y) {
    .Call('_umap_dCenteredPearson', PACKAGE = 'umap', x, y)
}

#' compute pearson correlation distances 
#'
#' @keywords internal
#' @param m matrix with raw data
#' @param origin index (1-based) of origin element
#' @param targets indexes (1-based) of target elements
#'
#' @return dCenteredPearson norms between origin and targets
mdCenteredPearson <- function(m, origin, targets) {
    .Call('_umap_mdCenteredPearson', PACKAGE = 'umap', m, origin, targets)
}

#' compute cosine dissimilarity between two vectors
#'
#' Note: values output from this function do not satisfy the triangle inequality
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return cosine dissimilarity between x and y
dCosine <- function(x, y) {
    .Call('_umap_dCosine', PACKAGE = 'umap', x, y)
}

#' compute cosine distances
#'
#' @keywords internal
#' @param m matrix with raw data
#' @param origin index (1-based) of origin element
#' @param targets indexes (1-based) of target elements
#'
#' @return dCosine norms between origin and targets
mdCosine <- function(m, origin, targets) {
    .Call('_umap_mdCosine', PACKAGE = 'umap', m, origin, targets)
}

#' perform a compound transformation on a vector, including clipping
#'
#' @keywords internal
#' @param x numeric vector
#' @param inner numeric constant
#' @param outer numeric constan
#'
#' @return numeric vector of same length as x, containing outer*clip4(inner*x)
clip4 <- function(x, inner, outer) {
    .Call('_umap_clip4', PACKAGE = 'umap', x, inner, outer)
}

#' run one epoch of the umap optimization
#'
#' @keywords internal
#' @param embedding matrix with embedding coordinates (coordinates along columns)
#' @param pairs matrix with rows: from to; indexes must be 0-based
#' @param adjust vector with 0/1 whether to adjust or not
#' @param nns vector with negative-neighbors-set size
#' @param book matrix with columns: eps, epns, eon2s, eons, nns (in that order)
#' @param abg vector with configuration parameters, a, b, gamma, move_other
#' @param alpha numeric learning rate for this epoch
#'
optimize_epoch <- function(embedding, pairs, adjust, nns, abg, alpha) {
    .Call('_umap_optimize_epoch', PACKAGE = 'umap', embedding, pairs, adjust, nns, abg, alpha)
}

