% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor_functions.R
\name{extract_sample_qc_flags}
\alias{extract_sample_qc_flags}
\title{Extract NMR sample QC flags from a data.frame of UK Biobank fields}
\usage{
extract_sample_qc_flags(x)
}
\arguments{
\item{x}{\code{data.frame} with column names "eid" followed by extracted
fields e.g. "23649-0.0", "23649-1.0", \dots, "23655-1.0".}
}
\value{
a \code{data.frame} or \code{data.table} with column names "eid"
       and "visit_index", followed by columns for each sample
       QC tag, e.g. "Shipment.Plate", \dots, "Low.Protein".
}
\description{
Given an input \code{data.frame} loaded from a dataset extracted by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
extracts the \href{https://biobank.ndph.ox.ac.uk/showcase/label.cgi?id=222}{UK Biobank fields}
corresponding to the
\href{https://biobank.ndph.ox.ac.uk/showcase/showcase/docs/nmrm_app4.pdf}{sample quality control flags for the NMR metabolomics biomarker data}
giving them short variable names.
}
\details{
Data sets extracted by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
have one row per UKB biobank participant whose project specific sample
identifier is given in the first column named "eid". Columns following this
have the format "<field_id>-<visit_index>.<repeat_index>", where here <field_id>
corresponds to a sample QC flag, and <visit_index> corresponds to the assessment
time point, e.g. 0 for baseline assessment, 1 for first repeat visit. For the
UKB NMR data, the <repeat_index> column is reserved for cases where biomarker
measurements have more than one QC Flag (see \code{\link{extract_biomarker_qc_flags}()}).

In the returned \code{data.frame} there is single column for each QC Flag,
with an additional column for the visit index. Rows are uniquely identifiable
by the combination of entries in columns "eid" and "visit_index". There are
currently no repeat measure data for the NMR biomarker data in UKB,
so no repeat_index column is returned.

This function will also work with data extracted by the \code{ukbtools} R
package.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
sample_qc_flags <- extract_sample_qc_flags(ukb_data)

}
