% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex_templates.R
\name{latex_journal_format}
\alias{latex_journal_format}
\title{UIUC Class Journal Format}
\usage{
latex_journal_format(..., keep_tex = TRUE, citation_package = "natbib")
}
\arguments{
\item{...}{Arguments to \code{rmarkdown::pdf_document}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{default} if neither package is to be used,
which means citations will be processed via the command
\command{pandoc-citeproc}.}
}
\value{
R Markdown output format to pass to
\code{\link[rmarkdown:render]{render}}
}
\description{
Modified version of the Journal of Statistical Software (JSS) Format
for creating a Journal of Statistical Software (JSS) articles. Adapted
from \url{http://www.jstatsoft.org/about/submissions}.
}
\details{
This format is largely based off of the \href{https://github.com/rstudio/rticles}{\code{rticles}}
of \code{jss_article}.
}
\examples{

\dontrun{
library(rmarkdown)
draft("MyArticle.Rmd", template = "latex_journal_format", package = "uiucthemes")
}

}
\references{
\href{https://github.com/rstudio/rticles}{\code{rticles}} package by JJ Allaire, R Foundation, Hadley Wickham, Journal of Statistical Software, Yihui Xie, Ramnath
Vaidyanathan, Association for Computing Machinery, Carl Boettiger, Elsevier, Karl Broman, Kirill
Mueller, Bastiaan Quast, Randall Pruim, Ben Marwick, Charlotte Wickham, Oliver Keyes and Miao Yu
(2017). rticles: Article Formats for R Markdown. R package version 0.4.1.
\url{https://CRAN.R-project.org/package=rticles}
}
\author{
JSS Editorial Staff for the Journal format, RStudio for \code{jss_article},
James Balamuta for the theme hook, and David Dalpiaz for skeleton content
}
