% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carelessReport.R
\name{carelessReport}
\alias{carelessReport}
\title{A report to help diagnosing careless responders}
\usage{
carelessReport(
  data,
  items = names(data),
  nFlags = 1,
  flagUnivar = 0.99,
  flagMultivar = 0.95,
  irvSplit = 4,
  headingLevel = 3,
  datasetName = NULL,
  responseTime = NULL,
  headingSuffix = " {.tabset}",
  digits = 2,
  missingSymbol = "Missing"
)
}
\arguments{
\item{data}{The dataframe.}

\item{items}{The items to look at.}

\item{nFlags}{How many indicators need to be flagged for
a participant to be considered suspect.}

\item{flagUnivar}{How extreme a score has to be for it
to be flagged as suspicous univariately.}

\item{flagMultivar}{This has not been implemented yet.}

\item{irvSplit}{Whether to split for the IRV, and if so,
in how many parts.}

\item{headingLevel}{The level of the heading in Markdown (the
number of \verb{#}s to include before the heading).}

\item{datasetName}{The name of the dataset to display (to override,
if desired).}

\item{responseTime}{If not \code{NULL}, the name of a column
containing the participants' response times.}

\item{headingSuffix}{The suffix to include; by default, set
such that the individual participants IRP plots are placed
in separate tabs.}

\item{digits}{The number of digits to round to.}

\item{missingSymbol}{How to represent missing values.}
}
\value{
NULL, invisibly; and prints the report.
}
\description{
This function wraps functions from the \code{careless} package
to help inspect and diagnose careless participants. It is
optimized for using in R Markdown files.
}
\examples{
### Get the BFI data taken from the `psych` package
dat <- ufs::bfi;

### Get the variable names for the regular items
bfiVars <-
  setdiff(names(dat),
          c("gender", "education", "age"));

### Inspect suspect participants, very conservatively to
### limit the output (these are 2800 participants).
carelessReport(data = dat,
               items = bfiVars,
               nFlags = 5);
}
