% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFigCapNumbering.R
\name{setFigCapNumbering}
\alias{setFigCapNumbering}
\title{Set caption numbering}
\usage{
setFigCapNumbering(
  captionName = "fig.cap",
  prefix = "Figure \%s: ",
  suffix = "",
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = 1
)
}
\arguments{
\item{captionName}{THe name of the caption; normally \code{fig.cap} or \code{tab.cap}.}

\item{prefix, suffix}{The prefix and suffix; any occurrences of \verb{\\\%s} will be replaced by the
number.}

\item{optionName}{THe name to use for the option that keeps track of the numbering.}

\item{resetCounterTo}{Whether to reset the counter (as stored in the options), and if so,
to what value (set to \code{FALSE} to prevent resetting).}
}
\value{
\code{NULL}, invisibly.
}
\description{
Set caption numbering
}
\examples{
setFigCapNumbering();

### For table captions
setFigCapNumbering("tab.cap", "Table \%s: ");
}
